<?php
$page_title = "Home";
require_once 'includes/header.php';
?>

<section class="hero">
    <div class="container">
        <h1>Flying Top Logistics</h1>
        <p>Your trusted partner for global cargo shipping and logistics solutions</p>
        <div class="hero-actions">
            <a href="/get-quote.php" class="btn btn-primary">Get a Quote</a>
            <a href="/track.php" class="btn btn-secondary">Track Shipment</a>
        </div>
    </div>
</section>

<section style="padding: 4rem 0;">
    <div class="container">
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-number">500+</div>
                <div class="stat-label">Successful Deliveries</div>
            </div>
            <div class="stat-card">
                <div class="stat-number">50+</div>
                <div class="stat-label">Countries Served</div>
            </div>
            <div class="stat-card">
                <div class="stat-number">24/7</div>
                <div class="stat-label">Customer Support</div>
            </div>
        </div>
        
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 2rem;">
            <div class="card">
                <h3 class="card-title">Air Cargo</h3>
                <p>Fast and secure air freight services for urgent deliveries worldwide.</p>
                <a href="/get-quote.php?type=air" class="btn btn-primary mt-2">Get Air Quote</a>
            </div>
            <div class="card">
                <h3 class="card-title">Sea Freight</h3>
                <p>Cost-effective ocean shipping for large cargo and bulk shipments.</p>
                <a href="/get-quote.php?type=sea" class="btn btn-primary mt-2">Get Sea Quote</a>
            </div>
            <div class="card">
                <h3 class="card-title">Track & Trace</h3>
                <p>Real-time tracking of your shipments from origin to destination.</p>
                <a href="/track.php" class="btn btn-secondary mt-2">Track Now</a>
            </div>
        </div>
    </div>
</section>

<?php require_once 'includes/footer.php'; ?>