<?php
require_once __DIR__ . '/../config/config.php';

function send_email($to, $subject, $message) {
    $config = require __DIR__ . '/../config/config.php';
    $smtp = $config['smtp'];
    
    // Create HTML email body
    $email_body = "
        <html>
        <head><title>" . htmlspecialchars($subject) . "</title></head>
        <body style='font-family: Arial, sans-serif; line-height: 1.6; color: #333;'>
            <div style='max-width: 600px; margin: 0 auto; padding: 20px;'>
                <div style='background: #0A1D37; color: white; padding: 20px; border-radius: 8px 8px 0 0;'>
                    <h2 style='margin: 0; color: #FBC02D;'>" . htmlspecialchars($config['app']['name']) . "</h2>
                </div>
                <div style='background: white; padding: 20px; border: 1px solid #eee; border-radius: 0 0 8px 8px;'>
                    <h3 style='color: #0A1D37; margin-top: 0;'>" . htmlspecialchars($subject) . "</h3>
                    " . nl2br(htmlspecialchars($message)) . "
                    <hr style='margin: 20px 0; border: none; border-top: 1px solid #eee;'>
                    <p style='color: #666; font-size: 12px; margin-bottom: 0;'>
                        Best regards,<br>
                        " . htmlspecialchars($config['app']['name']) . " Team<br>
                        Email: " . htmlspecialchars($smtp['user']) . "
                    </p>
                </div>
            </div>
        </body>
        </html>
    ";
    
    try {
        if ($smtp['enabled']) {
            // Use SMTP if enabled
            return send_smtp_email($to, $subject, $email_body, $smtp);
        } else {
            // Fallback to PHP mail() function
            $headers = [
                'From: ' . $config['app']['name'] . ' <' . $smtp['user'] . '>',
                'Reply-To: ' . $smtp['user'],
                'Content-Type: text/html; charset=UTF-8',
                'X-Mailer: PHP/' . phpversion(),
                'MIME-Version: 1.0'
            ];
            
            if (mail($to, $subject, $email_body, implode("\r\n", $headers))) {
                return ['success' => true];
            } else {
                return ['success' => false, 'error' => 'PHP mail() function failed'];
            }
        }
    } catch (Exception $e) {
        error_log("Email error: " . $e->getMessage());
        return ['success' => false, 'error' => $e->getMessage()];
    }
}

function send_smtp_email($to, $subject, $body, $smtp_config) {
    // Simple SMTP implementation without external dependencies
    $socket = @fsockopen($smtp_config['host'], $smtp_config['port'], $errno, $errstr, 30);
    
    if (!$socket) {
        return ['success' => false, 'error' => "Cannot connect to SMTP server: $errstr ($errno)"];
    }
    
    try {
        // Read server greeting
        $response = fgets($socket, 512);
        if (substr($response, 0, 3) !== '220') {
            throw new Exception("SMTP server error: $response");
        }
        
        // Send EHLO
        fputs($socket, "EHLO " . $_SERVER['HTTP_HOST'] . "\r\n");
        $response = fgets($socket, 512);
        
        // Start TLS if required
        if ($smtp_config['secure'] === 'tls') {
            fputs($socket, "STARTTLS\r\n");
            $response = fgets($socket, 512);
            if (substr($response, 0, 3) !== '220') {
                throw new Exception("STARTTLS failed: $response");
            }
            
            if (!stream_socket_enable_crypto($socket, true, STREAM_CRYPTO_METHOD_TLS_CLIENT)) {
                throw new Exception("Failed to enable TLS encryption");
            }
            
            // Send EHLO again after TLS
            fputs($socket, "EHLO " . $_SERVER['HTTP_HOST'] . "\r\n");
            $response = fgets($socket, 512);
        }
        
        // Authenticate
        fputs($socket, "AUTH LOGIN\r\n");
        $response = fgets($socket, 512);
        if (substr($response, 0, 3) !== '334') {
            throw new Exception("AUTH LOGIN failed: $response");
        }
        
        fputs($socket, base64_encode($smtp_config['user']) . "\r\n");
        $response = fgets($socket, 512);
        if (substr($response, 0, 3) !== '334') {
            throw new Exception("Username authentication failed: $response");
        }
        
        fputs($socket, base64_encode($smtp_config['pass']) . "\r\n");
        $response = fgets($socket, 512);
        if (substr($response, 0, 3) !== '235') {
            throw new Exception("Password authentication failed: $response");
        }
        
        // Send email
        fputs($socket, "MAIL FROM: <" . $smtp_config['user'] . ">\r\n");
        $response = fgets($socket, 512);
        if (substr($response, 0, 3) !== '250') {
            throw new Exception("MAIL FROM failed: $response");
        }
        
        fputs($socket, "RCPT TO: <$to>\r\n");
        $response = fgets($socket, 512);
        if (substr($response, 0, 3) !== '250') {
            throw new Exception("RCPT TO failed: $response");
        }
        
        fputs($socket, "DATA\r\n");
        $response = fgets($socket, 512);
        if (substr($response, 0, 3) !== '354') {
            throw new Exception("DATA command failed: $response");
        }
        
        // Email headers and body
        $email_data = "From: " . $smtp_config['user'] . "\r\n";
        $email_data .= "To: $to\r\n";
        $email_data .= "Subject: $subject\r\n";
        $email_data .= "Content-Type: text/html; charset=UTF-8\r\n";
        $email_data .= "MIME-Version: 1.0\r\n";
        $email_data .= "\r\n";
        $email_data .= $body . "\r\n";
        $email_data .= ".\r\n";
        
        fputs($socket, $email_data);
        $response = fgets($socket, 512);
        if (substr($response, 0, 3) !== '250') {
            throw new Exception("Email sending failed: $response");
        }
        
        // Quit
        fputs($socket, "QUIT\r\n");
        fclose($socket);
        
        return ['success' => true];
        
    } catch (Exception $e) {
        fclose($socket);
        return ['success' => false, 'error' => $e->getMessage()];
    }
}