<?php
session_start();
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_login();

// Get statistics
try {
    $stmt = $pdo->query("SELECT COUNT(*) as total_quotes FROM quotes");
    $total_quotes = $stmt->fetch()['total_quotes'];
    
    $stmt = $pdo->query("SELECT COUNT(*) as total_shipments FROM shipments");
    $total_shipments = $stmt->fetch()['total_shipments'];
    
    $stmt = $pdo->query("SELECT COUNT(*) as pending_shipments FROM shipments WHERE status = 'Pending'");
    $pending_shipments = $stmt->fetch()['pending_shipments'];
    
    // Recent quotes
    $stmt = $pdo->query("SELECT * FROM quotes ORDER BY created_at DESC LIMIT 5");
    $recent_quotes = $stmt->fetchAll();
    
    // Recent shipments
    $stmt = $pdo->query("SELECT * FROM shipments ORDER BY date_created DESC LIMIT 5");
    $recent_shipments = $stmt->fetchAll();
    
} catch (PDOException $e) {
    error_log("Dashboard error: " . $e->getMessage());
    $total_quotes = $total_shipments = $pending_shipments = 0;
    $recent_quotes = $recent_shipments = [];
}

$page_title = "Admin Dashboard";
require_once '../includes/header.php';
?>

<div class="container">
    <h1 style="margin-bottom: 2rem;">Dashboard</h1>
    
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-number"><?= $total_quotes ?></div>
            <div class="stat-label">Total Quotes</div>
        </div>
        <div class="stat-card">
            <div class="stat-number"><?= $total_shipments ?></div>
            <div class="stat-label">Total Shipments</div>
        </div>
        <div class="stat-card">
            <div class="stat-number"><?= $pending_shipments ?></div>
            <div class="stat-label">Pending Shipments</div>
        </div>
    </div>
    
    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 2rem;">
        <div class="card">
            <div class="card-header">
                <div class="flex justify-between items-center">
                    <h3 class="card-title">Recent Quotes</h3>
                    <a href="/admin/quotes.php" class="btn btn-small btn-primary">View All</a>
                </div>
            </div>
            
            <?php if (empty($recent_quotes)): ?>
                <p style="color: var(--medium-gray); text-align: center;">No quotes yet</p>
            <?php else: ?>
                <div class="table-container">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Reference</th>
                                <th>Name</th>
                                <th>Type</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recent_quotes as $quote): ?>
                                <tr>
                                    <td><?= htmlspecialchars($quote['ref_code']) ?></td>
                                    <td><?= htmlspecialchars($quote['name']) ?></td>
                                    <td><?= htmlspecialchars($quote['cargo_type']) ?></td>
                                    <td><?= date('M j, Y', strtotime($quote['created_at'])) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
        
        <div class="card">
            <div class="card-header">
                <div class="flex justify-between items-center">
                    <h3 class="card-title">Recent Shipments</h3>
                    <a href="/admin/shipments.php" class="btn btn-small btn-primary">View All</a>
                </div>
            </div>
            
            <?php if (empty($recent_shipments)): ?>
                <p style="color: var(--medium-gray); text-align: center;">No shipments yet</p>
            <?php else: ?>
                <div class="table-container">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Tracking</th>
                                <th>Customer</th>
                                <th>Status</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recent_shipments as $shipment): ?>
                                <tr>
                                    <td><?= htmlspecialchars($shipment['tracking_number']) ?></td>
                                    <td><?= htmlspecialchars($shipment['customer_name']) ?></td>
                                    <td>
                                        <span class="status-badge status-<?= strtolower(str_replace(' ', '', $shipment['status'])) ?>">
                                            <?= htmlspecialchars($shipment['status']) ?>
                                        </span>
                                    </td>
                                    <td><?= date('M j, Y', strtotime($shipment['date_created'])) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <div class="card">
        <h3 style="margin-bottom: 1rem;">Quick Actions</h3>
        <div style="display: flex; gap: 1rem; flex-wrap: wrap;">
            <a href="/admin/quotes.php" class="btn btn-secondary">Manage Quotes</a>
            <a href="/admin/shipments.php" class="btn btn-secondary">Manage Shipments</a>
            <a href="/admin/shipment_form.php" class="btn btn-primary">Create New Shipment</a>
        </div>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>