<?php
require_once __DIR__ . '/auth.php';
$config = require __DIR__ . '/../config/config.php';
$app_name = $config['app']['name'];
$current_page = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($page_title) ? $page_title . ' - ' . $app_name : $app_name ?></title>
    <link rel="stylesheet" href="/assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <nav class="navbar">
        <div class="nav-container">
            <div class="nav-brand">
                <a href="/index.php"><?= htmlspecialchars($app_name) ?></a>
            </div>
            <div class="nav-menu" id="navMenu">
                
                <?php if (is_logged_in()): ?>
                    <a href="/admin/dashboard.php" class="nav-link <?= strpos($_SERVER['REQUEST_URI'], '/admin/') !== false ? 'active' : '' ?>">Admin</a>
                    <a href="/admin/logout.php" class="nav-link">Logout</a>
                <?php else: ?>
                    
                <?php endif; ?>
            </div>
            <div class="nav-toggle" id="navToggle">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
    </nav>
    <main class="main-content">