<?php
$page_title = "Get a Quote";
require_once 'includes/header.php';

$success_message = $_SESSION['quote_success'] ?? null;
unset($_SESSION['quote_success']);

$cargo_type_default = $_GET['type'] ?? '';
if ($cargo_type_default === 'air') {
    $cargo_type_default = 'Air';
} elseif ($cargo_type_default === 'sea') {
    $cargo_type_default = 'Sea';
}
?>

<div class="container" style="max-width: 800px; margin: 0 auto;">
    <?php if ($success_message): ?>
        <div class="alert alert-success">
            <?= htmlspecialchars($success_message) ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Request a Quote</h2>
            <p style="color: var(--medium-gray);">Fill out the form below and we'll get back to you with a competitive quote within 24 hours.</p>
        </div>
        
        <form method="POST" action="/api/quote_submit.php" data-validate>
            <?= csrf_field() ?>
            
            <div class="grid-cols-2">
                <div class="form-group">
                    <label for="name" class="form-label">Full Name *</label>
                    <input type="text" id="name" name="name" class="form-control" required>
                </div>
                
                <div class="form-group">
                    <label for="phone" class="form-label">Phone Number *</label>
                    <input type="tel" id="phone" name="phone" class="form-control" required>
                </div>
            </div>
            
            <div class="form-group">
                <label for="email" class="form-label">Email Address *</label>
                <input type="email" id="email" name="email" class="form-control" required>
            </div>
            
            <div class="grid-cols-2">
                <div class="form-group">
                    <label for="cargo_type" class="form-label">Cargo Type *</label>
                    <select id="cargo_type" name="cargo_type" class="form-control form-select" required>
                        <option value="">Select Type</option>
                        <option value="Air" <?= $cargo_type_default === 'Air' ? 'selected' : '' ?>>Air Freight</option>
                        <option value="Sea" <?= $cargo_type_default === 'Sea' ? 'selected' : '' ?>>Sea Freight</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="origin" class="form-label">Origin *</label>
                    <input type="text" id="origin" name="origin" class="form-control" placeholder="e.g., Lagos, Nigeria" required>
                </div>
            </div>
            
            <div class="form-group">
                <label for="destination" class="form-label">Destination *</label>
                <input type="text" id="destination" name="destination" class="form-control" placeholder="e.g., London, UK" required>
            </div>
            
            <div class="form-group">
                <label for="description" class="form-label">Description of Goods *</label>
                <textarea id="description" name="description" class="form-control" placeholder="Please provide detailed description including quantity, weight, dimensions, and any special requirements" required></textarea>
            </div>
            
            <button type="submit" class="btn btn-primary" style="width: 100%;">
                Submit Quote Request
            </button>
        </form>
    </div>
    
    <div class="card">
       <div style="display:flex; justify-content:center; align-items:center; height:5vh;">
  <a href="https://flyingtoplogistics.com.ng/" 
     style="display:inline-block; padding:12px 24px; background:#ff6600; color:#fff; text-decoration:none; border-radius:8px; font-weight:bold; font-size:16px;">
    Back to Home
  </a>
</div>

         
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>