<?php
require_once '../includes/db.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

$tracking_number = trim($_GET['tracking'] ?? '');

if (empty($tracking_number)) {
    echo json_encode(['found' => false, 'error' => 'Tracking number is required']);
    exit;
}

try {
    $stmt = $pdo->prepare("
        SELECT tracking_number, customer_name, customer_email, cargo_type, 
               origin, destination, description, status, eta, 
               DATE_FORMAT(last_updated, '%Y-%m-%d %H:%i:%s') as last_updated,
               shipping_cost
        FROM shipments 
        WHERE tracking_number = ?
    ");
    
    $stmt->execute([$tracking_number]);
    $shipment = $stmt->fetch();
    
    if ($shipment) {
        echo json_encode([
            'found' => true,
            'data' => $shipment
        ]);
    } else {
        echo json_encode(['found' => false]);
    }
    
} catch (PDOException $e) {
    error_log("Tracking lookup error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['found' => false, 'error' => 'Database error']);
}