<?php
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_login();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: /admin/shipments.php');
    exit;
}

if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
    $_SESSION['error_message'] = "Invalid request. Please try again.";
    header('Location: /admin/shipments.php');
    exit;
}

$shipment_id = intval($_POST['shipment_id'] ?? 0);

if ($shipment_id <= 0) {
    $_SESSION['error_message'] = "Invalid shipment ID.";
    header('Location: /admin/shipments.php');
    exit;
}

try {
    $stmt = $pdo->prepare("DELETE FROM shipments WHERE id = ?");
    $stmt->execute([$shipment_id]);
    
    if ($stmt->rowCount() > 0) {
        $_SESSION['success_message'] = "Shipment deleted successfully.";
    } else {
        $_SESSION['error_message'] = "Shipment not found.";
    }
    
} catch (PDOException $e) {
    error_log("Delete shipment error: " . $e->getMessage());
    $_SESSION['error_message'] = "Failed to delete shipment. Please try again.";
}

header('Location: /admin/shipments.php');
exit;