<?php
$page_title = "Track Your Shipment";
require_once 'includes/header.php';
?>

<div class="container" style="max-width: 800px; margin: 0 auto;">
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Track Your Shipment</h2>
            <p style="color: var(--medium-gray);">Enter your tracking number to get real-time updates on your shipment status.</p>
        </div>
        
        <form id="trackForm">
            <div class="form-group">
                <label for="trackingNumber" class="form-label">Tracking Number</label>
                <input 
                    type="text" 
                    id="trackingNumber" 
                    name="trackingNumber" 
                    class="form-control" 
                    placeholder="e.g., FTL2025-001"
                    required
                >
            </div>
            
            <button type="submit" class="btn btn-primary" style="width: 100%;">
                Track Shipment
            </button>
        </form>
    </div>
    
    <div id="trackingResults"></div>
    
    <div class="card">
        <h3 style="margin-bottom: 1rem;">Need Help?</h3>
        <p style="margin-bottom: 1rem;">If you can't find your shipment or need assistance:</p>
        <div style="display: flex; gap: 1rem; flex-wrap: wrap;">
            <a href="/get-quote.php" class="btn btn-secondary">Get New Quote</a>
            <a href="mailto:support@flyingtoplogistics.com" class="btn btn-primary">Contact Support</a>
        </div>
        <div style="display:flex; justify-content:center; align-items:center; height:20vh;">
  <a href="https://flyingtoplogistics.com.ng/" 
     style="display:inline-block; padding:12px 24px; background:#ff6600; color:#fff; text-decoration:none; border-radius:8px; font-weight:bold; font-size:16px;">
    Back to Home
  </a>
</div>
    </div>
</div>




<?php require_once 'includes/footer.php'; ?>