<?php
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_once '../includes/email.php';
require_login();

$quote_id = $_GET['quote_id'] ?? null;
$shipment_id = $_GET['shipment_id'] ?? null;

$recipient = null;
$subject_default = '';

// Load quote or shipment data
if ($quote_id) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM quotes WHERE id = ?");
        $stmt->execute([$quote_id]);
        $quote = $stmt->fetch();
        
        if ($quote) {
            $recipient = $quote['email'];
            $subject_default = "Quote Response - " . $quote['ref_code'];
        }
    } catch (PDOException $e) {
        error_log("Load quote error: " . $e->getMessage());
    }
} elseif ($shipment_id) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM shipments WHERE id = ?");
        $stmt->execute([$shipment_id]);
        $shipment = $stmt->fetch();
        
        if ($shipment) {
            $recipient = $shipment['customer_email'];
            $subject_default = "Shipment Update - " . $shipment['tracking_number'];
        }
    } catch (PDOException $e) {
        error_log("Load shipment error: " . $e->getMessage());
    }
}

if (!$recipient) {
    $_SESSION['error_message'] = "Invalid quote or shipment ID.";
    header('Location: /admin/dashboard.php');
    exit;
}

// Handle form submission
if ($_POST) {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        $error_message = "Invalid request. Please try again.";
    } else {
        $to = trim($_POST['to'] ?? '');
        $subject = trim($_POST['subject'] ?? '');
        $message = trim($_POST['message'] ?? '');
        
        if (empty($to) || empty($subject) || empty($message)) {
            $error_message = "All fields are required.";
        } elseif (!filter_var($to, FILTER_VALIDATE_EMAIL)) {
            $error_message = "Invalid email address.";
        } else {
            // Send email using the email helper
            $email_result = send_email($to, $subject, $message);
            
            if ($email_result['success']) {
                $_SESSION['success_message'] = "Email sent successfully to $to";
                $redirect = $quote_id ? '/admin/quotes.php' : '/admin/shipments.php';
                header("Location: $redirect");
                exit;
            } else {
                $error_message = "Failed to send email: " . $email_result['error'];
            }
        }
    }
}

$page_title = "Send Email";
require_once '../includes/header.php';
?>

<div class="container" style="max-width: 800px; margin: 0 auto;">
    <div class="flex justify-between items-center mb-3">
        <h1>Send Email</h1>
        <a href="<?= $quote_id ? '/admin/quotes.php' : '/admin/shipments.php' ?>" class="btn btn-secondary">← Back</a>
    </div>
    
    <?php if (isset($error_message)): ?>
        <div class="alert alert-danger">
            <?= htmlspecialchars($error_message) ?>
        </div>
    <?php endif; ?>
    
    <div class="card">
        <form method="POST" data-validate>
            <?= csrf_field() ?>
            
            <div class="form-group">
                <label for="to" class="form-label">To *</label>
                <input type="email" id="to" name="to" class="form-control" 
                       value="<?= htmlspecialchars($recipient) ?>" required readonly>
            </div>
            
            <div class="form-group">
                <label for="subject" class="form-label">Subject *</label>
                <input type="text" id="subject" name="subject" class="form-control" 
                       value="<?= htmlspecialchars($subject_default) ?>" required>
            </div>
            
            <div class="form-group">
                <label for="message" class="form-label">Message *</label>
                <textarea id="message" name="message" class="form-control" rows="10" required
                          placeholder="Write your message here..."></textarea>
            </div>
            
            <div style="display: flex; gap: 1rem; justify-content: flex-end;">
                <a href="<?= $quote_id ? '/admin/quotes.php' : '/admin/shipments.php' ?>" class="btn btn-secondary">Cancel</a>
                <button type="submit" class="btn btn-primary">Send Email</button>
            </div>
        </form>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>