<?php
session_start();
require_once 'includes/auth.php';

if (is_logged_in()) {
    header('Location: /admin/dashboard.php');
    exit;
}

$error_message = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        $error_message = "Invalid request. Please try again.";
    } else {
        $username = trim($_POST['username'] ?? '');
        $password = $_POST['password'] ?? '';
        
        if (login($username, $password)) {
            header('Location: /admin/dashboard.php');
            exit;
        } else {
            $error_message = "Invalid login credentials. Please try again.";
            // Basic rate limiting
            sleep(2);
        }
    }
}

$page_title = "Admin Login";
require_once 'includes/header.php';
?>

<div class="container" style="max-width: 500px; margin: 4rem auto;">
    <div class="card">
        <div class="card-header text-center">
            <h2 class="card-title">Admin Login</h2>
            <p style="color: var(--medium-gray);">Sign in to access the admin dashboard</p>
        </div>
        
        <?php if ($error_message): ?>
            <div class="alert alert-danger">
                <?= htmlspecialchars($error_message) ?>
            </div>
        <?php endif; ?>
        
        <form method="POST" data-validate>
            <?= csrf_field() ?>
            
            <div class="form-group">
                <label for="username" class="form-label">Username</label>
                <input type="text" id="username" name="username" class="form-control" required autofocus>
            </div>
            
            <div class="form-group">
                <label for="password" class="form-label">Password</label>
                <input type="password" id="password" name="password" class="form-control" required>
            </div>
            
            <button type="submit" class="btn btn-primary" style="width: 100%;">
                Sign In
            </button>
        </form>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>